uniform sampler2D texTo;
uniform sampler2D texFrom;

uniform float crossfader;
uniform float levelFrom;
uniform float levelTo;

void main()
{
	vec2 uv = gl_TexCoord[0].st;
  
  float segment_progress;
	if (crossfader < 0.5)
		segment_progress = 1.0 - crossfader * 2.0;
	else
		segment_progress = (crossfader - 0.5) * 2.0;

	float pixels = 5.0 + 1000.0 * segment_progress * segment_progress;
	vec2 newUV = floor(uv.xy*pixels+0.5) / pixels;

	vec4 color1 = texture2D(texFrom, newUV);
  color1.a = levelFrom;
	vec4 color2 = texture2D(texTo, newUV);
  color2.a = levelTo;

	gl_FragColor = mix(color1, color2, clamp((crossfader - 0.4) / 0.2,0.0,1.0));
}